#Region _Memory

Func _MEMORYOPEN($IV_PID, $IV_DESIREDACCESS = 2035711, $IV_INHERITHANDLE = 1)
	If Not ProcessExists($IV_PID) Then
		SetError(1)
		Return 0
	EndIf
	Local $AH_HANDLE[2] = [DllOpen("kernel32.dll")]
	If @error Then
		SetError(2)
		Return 0
	EndIf
	Local $AV_OPENPROCESS = DllCall($AH_HANDLE[0], "int", "OpenProcess", "int", $IV_DESIREDACCESS, "int", $IV_INHERITHANDLE, "int", $IV_PID)
	If @error Then
		DllClose($AH_HANDLE[0])
		SetError(3)
		Return 0
	EndIf
	$AH_HANDLE[1] = $AV_OPENPROCESS[0]
	Return $AH_HANDLE
EndFunc


Func _MEMORYREAD($IV_ADDRESS, $AH_HANDLE, $SV_TYPE = "dword")
	If Not IsArray($AH_HANDLE) Then
		SetError(1)
		Return 0
	EndIf
	Local $V_BUFFER = DllStructCreate($SV_TYPE)
	If @error Then
		SetError(@error + 1)
		Return 0
	EndIf
	DllCall($AH_HANDLE[0], "int", "ReadProcessMemory", "int", $AH_HANDLE[1], "int", $IV_ADDRESS, "ptr", DllStructGetPtr($V_BUFFER), "int", DllStructGetSize($V_BUFFER), "int", "")
	If Not @error Then
		Local $V_VALUE = DllStructGetData($V_BUFFER, 1)
		Return $V_VALUE
	Else
		SetError(6)
		Return 0
	EndIf
EndFunc


Func _MEMORYWRITE($IV_ADDRESS, $AH_HANDLE, $V_DATA, $SV_TYPE = "dword")
	If Not IsArray($AH_HANDLE) Then
		SetError(1)
		Return 0
	EndIf
	Local $V_BUFFER = DllStructCreate($SV_TYPE)
	If @error Then
		SetError(@error + 1)
		Return 0
	Else
		DllStructSetData($V_BUFFER, 1, $V_DATA)
		If @error Then
			SetError(6)
			Return 0
		EndIf
	EndIf
	DllCall($AH_HANDLE[0], "int", "WriteProcessMemory", "int", $AH_HANDLE[1], "int", $IV_ADDRESS, "ptr", DllStructGetPtr($V_BUFFER), "int", DllStructGetSize($V_BUFFER), "int", "")
	If Not @error Then
		Return 1
	Else
		SetError(7)
		Return 0
	EndIf
EndFunc


Func _MEMORYCLOSE($AH_HANDLE)
	If Not IsArray($AH_HANDLE) Then
		SetError(1)
		Return 0
	EndIf
	DllCall($AH_HANDLE[0], "int", "CloseHandle", "int", $AH_HANDLE[1])
	If Not @error Then
		DllClose($AH_HANDLE[0])
		Return 1
	Else
		DllClose($AH_HANDLE[0])
		SetError(2)
		Return 0
	EndIf
EndFunc


Func SETPRIVILEGE($PRIVILEGE, $BENABLE)
	Const $TOKEN_ADJUST_PRIVILEGES = 32
	Const $TOKEN_QUERY = 8
	Const $SE_PRIVILEGE_ENABLED = 2
	Local $HTOKEN, $SP_AUXRET, $SP_RET, $HCURRPROCESS, $NTOKENS, $NTOKENINDEX, $PRIV
	$NTOKENS = 1
	$LUID = DllStructCreate("dword;int")
	If IsArray($PRIVILEGE) Then $NTOKENS = UBound($PRIVILEGE)
	$TOKEN_PRIVILEGES = DllStructCreate("dword;dword[" & (3 * $NTOKENS) & "]")
	$NEWTOKEN_PRIVILEGES = DllStructCreate("dword;dword[" & (3 * $NTOKENS) & "]")
	$HCURRPROCESS = DllCall("kernel32.dll", "hwnd", "GetCurrentProcess")
	$SP_AUXRET = DllCall("advapi32.dll", "int", "OpenProcessToken", "hwnd", $HCURRPROCESS[0], "int", BitOR($TOKEN_ADJUST_PRIVILEGES, $TOKEN_QUERY), "int_ptr", 0)
	If $SP_AUXRET[0] Then
		$HTOKEN = $SP_AUXRET[3]
		DllStructSetData($TOKEN_PRIVILEGES, 1, 1)
		$NTOKENINDEX = 1
		While $NTOKENINDEX <= $NTOKENS
			If IsArray($PRIVILEGE) Then
				$PRIV = $PRIVILEGE[$NTOKENINDEX - 1]
			Else
				$PRIV = $PRIVILEGE
			EndIf
			$RET = DllCall("advapi32.dll", "int", "LookupPrivilegeValue", "str", "", "str", $PRIV, "ptr", DllStructGetPtr($LUID))
			If $RET[0] Then
				If $BENABLE Then
					DllStructSetData($TOKEN_PRIVILEGES, 2, $SE_PRIVILEGE_ENABLED, (3 * $NTOKENINDEX))
				Else
					DllStructSetData($TOKEN_PRIVILEGES, 2, 0, (3 * $NTOKENINDEX))
				EndIf
				DllStructSetData($TOKEN_PRIVILEGES, 2, DllStructGetData($LUID, 1), (3 * ($NTOKENINDEX - 1)) + 1)
				DllStructSetData($TOKEN_PRIVILEGES, 2, DllStructGetData($LUID, 2), (3 * ($NTOKENINDEX - 1)) + 2)
				DllStructSetData($LUID, 1, 0)
				DllStructSetData($LUID, 2, 0)
			EndIf
			$NTOKENINDEX += 1
		WEnd
		$RET = DllCall("advapi32.dll", "int", "AdjustTokenPrivileges", "hwnd", $HTOKEN, "int", 0, "ptr", DllStructGetPtr($TOKEN_PRIVILEGES), "int", DllStructGetSize($NEWTOKEN_PRIVILEGES), "ptr", DllStructGetPtr($NEWTOKEN_PRIVILEGES), "int_ptr", 0)
		$F = DllCall("kernel32.dll", "int", "GetLastError")
	EndIf
	$NEWTOKEN_PRIVILEGES = 0
	$TOKEN_PRIVILEGES = 0
	$LUID = 0
	If $SP_AUXRET[0] = 0 Then Return 0
	$SP_AUXRET = DllCall("kernel32.dll", "int", "CloseHandle", "hwnd", $HTOKEN)
	If Not $RET[0] And Not $SP_AUXRET[0] Then Return 0
	Return $RET[0]
EndFunc


Func _MEMORYPOINTERREAD($IV_ADDRESS, $AH_HANDLE, $AV_OFFSET, $SV_TYPE = "dword")
	If IsArray($AV_OFFSET) Then
		If IsArray($AH_HANDLE) Then
			Local $IV_POINTERCOUNT = UBound($AV_OFFSET) - 1
		Else
			SetError(2)
			Return 0
		EndIf
	Else
		SetError(1)
		Return 0
	EndIf
	Local $IV_DATA[2], $I
	Local $V_BUFFER = DllStructCreate("dword")
	For $I = 0 To $IV_POINTERCOUNT
		If $I = $IV_POINTERCOUNT Then
			$V_BUFFER = DllStructCreate($SV_TYPE)
			If @error Then
				SetError(@error + 2)
				Return 0
			EndIf
			$IV_ADDRESS = "0x" & Hex($IV_DATA[1] + $AV_OFFSET[$I])
			DllCall($AH_HANDLE[0], "int", "ReadProcessMemory", "int", $AH_HANDLE[1], "int", $IV_ADDRESS, "ptr", DllStructGetPtr($V_BUFFER), "int", DllStructGetSize($V_BUFFER), "int", "")
			If @error Then
				SetError(7)
				Return 0
			EndIf
			$IV_DATA[1] = DllStructGetData($V_BUFFER, 1)
		ElseIf $I = 0 Then
			DllCall($AH_HANDLE[0], "int", "ReadProcessMemory", "int", $AH_HANDLE[1], "int", $IV_ADDRESS, "ptr", DllStructGetPtr($V_BUFFER), "int", DllStructGetSize($V_BUFFER), "int", "")
			If @error Then
				SetError(7)
				Return 0
			EndIf
			$IV_DATA[1] = DllStructGetData($V_BUFFER, 1)
		Else
			$IV_ADDRESS = "0x" & Hex($IV_DATA[1] + $AV_OFFSET[$I])
			DllCall($AH_HANDLE[0], "int", "ReadProcessMemory", "int", $AH_HANDLE[1], "int", $IV_ADDRESS, "ptr", DllStructGetPtr($V_BUFFER), "int", DllStructGetSize($V_BUFFER), "int", "")
			If @error Then
				SetError(7)
				Return 0
			EndIf
			$IV_DATA[1] = DllStructGetData($V_BUFFER, 1)
		EndIf
	Next
	$IV_DATA[0] = $IV_ADDRESS
	Return $IV_DATA
EndFunc

#EndRegion
Dim $OPCODE = ""
Dim $OPDEBUG = False

Func INT2HEX($VALUE, $N)
	Dim $TMP1, $TMP2, $I
	$TMP1 = StringRight("0000000" & Hex($VALUE), $N)
	For $I = 0 To StringLen($TMP1) / 2 - 1
		$TMP2 = $TMP2 & StringMid($TMP1, StringLen($TMP1) - 1 - 2 * $I, 2)
	Next
	Return $TMP2
EndFunc


Func LEAVE()
	$OPCODE = $OPCODE & "C9"
EndFunc


Func PUSHAD()
	$OPCODE = $OPCODE & "60"
EndFunc


Func POPAD()
	$OPCODE = $OPCODE & "61"
EndFunc


Func NOP()
	$OPCODE = $OPCODE & "90"
EndFunc


Func RET()
	$OPCODE = $OPCODE & "C3"
EndFunc


Func RETA($I)
	$OPCODE = $OPCODE & INT2HEX($I, 4)
EndFunc


Func IN_AL_DX()
	$OPCODE = $OPCODE & "EC"
EndFunc


Func TEST_EAX_EAX()
	$OPCODE = $OPCODE & "85C0"
EndFunc


Func ADD_EAX_EDX()
	$OPCODE = $OPCODE & "03C2"
EndFunc


Func ADD_EBX_EAX()
	$OPCODE = $OPCODE & "03D8"
EndFunc


Func ADD_EAX_DWORD_PTR($I)
	$OPCODE = $OPCODE & "0305" & INT2HEX($I, 8)
EndFunc


Func ADD_EBX_DWORD_PTR($I)
	$OPCODE = $OPCODE & "031D" & INT2HEX($I, 8)
EndFunc


Func ADD_EBP_DWORD_PTR($I)
	$OPCODE = $OPCODE & "032D" & INT2HEX($I, 8)
EndFunc


Func ADD_EAX($I)
	$OPCODE = $OPCODE & "05" & INT2HEX($I, 8)
EndFunc


Func ADD_EBX($I)
	$OPCODE = $OPCODE & "83C3" & INT2HEX($I, 8)
EndFunc


Func ADD_ECX($I)
	$OPCODE = $OPCODE & "83C1" & INT2HEX($I, 8)
EndFunc


Func ADD_EDX($I)
	$OPCODE = $OPCODE & "83C2" & INT2HEX($I, 8)
EndFunc


Func ADD_ESI($I)
	$OPCODE = $OPCODE & "83C6" & INT2HEX($I, 8)
EndFunc


Func ADD_ESP($I)
	$OPCODE = $OPCODE & "83C4" & INT2HEX($I, 8)
EndFunc


Func CALL_EAX()
	$OPCODE = $OPCODE & "FFD0"
EndFunc


Func CALL_EBX()
	$OPCODE = $OPCODE & "FFD3"
EndFunc


Func CALL_ECX()
	$OPCODE = $OPCODE & "FFD1"
EndFunc


Func CALL_EDX()
	$OPCODE = $OPCODE & "FFD2"
EndFunc


Func CALL_ESI()
	$OPCODE = $OPCODE & "FFD2"
EndFunc


Func CALL_ESP()
	$OPCODE = $OPCODE & "FFD4"
EndFunc


Func CALL_EBP()
	$OPCODE = $OPCODE & "FFD5"
EndFunc


Func CALL_EDI()
	$OPCODE = $OPCODE & "FFD7"
EndFunc


Func CALL_DWORD_PTR($I)
	$OPCODE = $OPCODE & "FF15" & INT2HEX($I, 8)
EndFunc


Func CALL_DWORD_PTR_EAX()
	$OPCODE = $OPCODE & "FF10"
EndFunc


Func CALL_DWORD_PTR_EBX()
	$OPCODE = $OPCODE & "FF13"
EndFunc


Func CMP_EAX($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "83F8" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "3D" & INT2HEX($I, 8)
	EndIf
EndFunc


Func CMP_EAX_EDX()
	$OPCODE = $OPCODE & "3BC2"
EndFunc


Func CMP_EAX_DWORD_PTR($I)
	$OPCODE = $OPCODE & "3B05" & INT2HEX($I, 8)
EndFunc


Func CMP_DWORD_PTR_EAX($I)
	$OPCODE = $OPCODE & "3905" & INT2HEX($I, 8)
EndFunc


Func DEC_EAX()
	$OPCODE = $OPCODE & "48"
EndFunc


Func DEC_EBX()
	$OPCODE = $OPCODE & "4B"
EndFunc


Func DEC_ECX()
	$OPCODE = $OPCODE & "49"
EndFunc


Func DEC_EDX()
	$OPCODE = $OPCODE & "4A"
EndFunc


Func IDIV_EAX()
	$OPCODE = $OPCODE & "F7F8"
EndFunc


Func IDIV_EBX()
	$OPCODE = $OPCODE & "F7FB"
EndFunc


Func IDIV_ECX()
	$OPCODE = $OPCODE & "F7F9"
EndFunc


Func IDIV_EDX()
	$OPCODE = $OPCODE & "F7FA"
EndFunc


Func IMUL_EAX_EDX()
	$OPCODE = $OPCODE & "0FAFC2"
EndFunc


Func IMUL_EAX($I)
	$OPCODE = $OPCODE & "6BC0" & INT2HEX($I, 2)
EndFunc


Func IMULB_EAX($I)
	$OPCODE = $OPCODE & "69C0" & INT2HEX($I, 8)
EndFunc


Func INC_EAX()
	$OPCODE = $OPCODE & "40"
EndFunc


Func INC_EBX()
	$OPCODE = $OPCODE & "43"
EndFunc


Func INC_ECX()
	$OPCODE = $OPCODE & "41"
EndFunc


Func INC_EDX()
	$OPCODE = $OPCODE & "42"
EndFunc


Func INC_EDI()
	$OPCODE = $OPCODE & "47"
EndFunc


Func INC_ESI()
	$OPCODE = $OPCODE & "46"
EndFunc


Func INC_DWORD_PTR_EAX()
	$OPCODE = $OPCODE & "FF00"
EndFunc


Func INC_DWORD_PTR_EBX()
	$OPCODE = $OPCODE & "FF03"
EndFunc


Func INC_DWORD_PTR_ECX()
	$OPCODE = $OPCODE & "FF01"
EndFunc


Func INC_DWORD_PTR_EDX()
	$OPCODE = $OPCODE & "FF02"
EndFunc


Func JMP_EAX()
	$OPCODE = $OPCODE & "FFE0"
EndFunc


Func MOV_DWORD_PTR_EAX($I)
	$OPCODE = $OPCODE & "A3" & INT2HEX($I, 8)
EndFunc


Func MOV_EAX($I)
	$OPCODE = $OPCODE & "B8" & INT2HEX($I, 8)
EndFunc


Func MOV_EBX($I)
	$OPCODE = $OPCODE & "BB" & INT2HEX($I, 8)
EndFunc


Func MOV_ECX($I)
	$OPCODE = $OPCODE & "B9" & INT2HEX($I, 8)
EndFunc


Func MOV_EDX($I)
	$OPCODE = $OPCODE & "BA" & INT2HEX($I, 8)
EndFunc


Func MOV_ESI($I)
	$OPCODE = $OPCODE & "BE" & INT2HEX($I, 8)
EndFunc


Func MOV_ESP($I)
	$OPCODE = $OPCODE & "BC" & INT2HEX($I, 8)
EndFunc


Func MOV_EBP($I)
	$OPCODE = $OPCODE & "BD" & INT2HEX($I, 8)
EndFunc


Func MOV_EDI($I)
	$OPCODE = $OPCODE & "BF" & INT2HEX($I, 8)
EndFunc


Func MOV_EBX_DWORD_PTR($I)
	$OPCODE = $OPCODE & "8B1D" & INT2HEX($I, 8)
EndFunc


Func MOV_ECX_DWORD_PTR($I)
	$OPCODE = $OPCODE & "8B0D" & INT2HEX($I, 8)
EndFunc


Func MOV_EAX_DWORD_PTR($I)
	$OPCODE = $OPCODE & "A1" & INT2HEX($I, 8)
EndFunc


Func MOV_EDX_DWORD_PTR($I)
	$OPCODE = $OPCODE & "8B15" & INT2HEX($I, 8)
EndFunc


Func MOV_ESI_DWORD_PTR($I)
	$OPCODE = $OPCODE & "8B35" & INT2HEX($I, 8)
EndFunc


Func MOV_ESP_DWORD_PTR($I)
	$OPCODE = $OPCODE & "8B25" & INT2HEX($I, 8)
EndFunc


Func MOV_EBP_DWORD_PTR($I)
	$OPCODE = $OPCODE & "8B2D" & INT2HEX($I, 8)
EndFunc


Func MOV_EAX_DWORD_PTR_EAX()
	$OPCODE = $OPCODE & "8B00"
EndFunc


Func MOV_EAX_DWORD_PTR_EBP()
	$OPCODE = $OPCODE & "8B4500"
EndFunc


Func MOV_EAX_DWORD_PTR_EBX()
	$OPCODE = $OPCODE & "8B03"
EndFunc


Func MOV_EAX_DWORD_PTR_ECX()
	$OPCODE = $OPCODE & "8B01"
EndFunc


Func MOV_EAX_DWORD_PTR_EDX()
	$OPCODE = $OPCODE & "8B02"
EndFunc


Func MOV_EAX_DWORD_PTR_EDI()
	$OPCODE = $OPCODE & "8B07"
EndFunc


Func MOV_EAX_DWORD_PTR_ESP()
	$OPCODE = $OPCODE & "8B0424"
EndFunc


Func MOV_EAX_DWORD_PTR_ESI()
	$OPCODE = $OPCODE & "8B06"
EndFunc


Func MOV_EAX_DWORD_PTR_EAX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B40" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B80" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EAX_DWORD_PTR_ESP_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B4424" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B8424" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EAX_DWORD_PTR_EBX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B43" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B83" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EAX_DWORD_PTR_ECX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B41" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B81" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EAX_DWORD_PTR_EDX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B42" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B82" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EAX_DWORD_PTR_EDI_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B47" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B87" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EAX_DWORD_PTR_EBP_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B45" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B85" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EAX_DWORD_PTR_ESI_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B46" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B86" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EBX_DWORD_PTR_EAX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B58" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B98" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EBX_DWORD_PTR_ESP_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B5C24" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B9C24" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EBX_DWORD_PTR_EBX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B5B" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B9B" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EBX_DWORD_PTR_ECX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B59" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B99" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EBX_DWORD_PTR_EDX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B5A" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B9A" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EBX_DWORD_PTR_EDI_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B5F" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B9F" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EBX_DWORD_PTR_EBP_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B5D" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B9D" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EBX_DWORD_PTR_ESI_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B5E" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B9E" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_ECX_DWORD_PTR_EAX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B48" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B88" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_ECX_DWORD_PTR_ESP_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B4C24" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B8C24" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_ECX_DWORD_PTR_EBX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B4B" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B8B" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_ECX_DWORD_PTR_ECX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B49" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B89" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_ECX_DWORD_PTR_EDX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B4A" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B8A" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_ECX_DWORD_PTR_EDI_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B4F" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B8F" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_ECX_DWORD_PTR_EBP_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B4D" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B8D" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_ECX_DWORD_PTR_ESI_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B4E" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B8E" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EDX_DWORD_PTR_EAX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B50" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B90" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EDX_DWORD_PTR_ESP_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B5424" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B9424" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EDX_DWORD_PTR_EBX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B53" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B93" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EDX_DWORD_PTR_ECX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B51" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B91" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EDX_DWORD_PTR_EDX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B52" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B92" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EDX_DWORD_PTR_EDI_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B57" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B97" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EDX_DWORD_PTR_EBP_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B55" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B95" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EDX_DWORD_PTR_ESI_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8B56" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8B96" & INT2HEX($I, 8)
	EndIf
EndFunc


Func MOV_EBX_DWORD_PTR_EAX()
	$OPCODE = $OPCODE & "8B18"
EndFunc


Func MOV_EBX_DWORD_PTR_EBP()
	$OPCODE = $OPCODE & "8B5D00"
EndFunc


Func MOV_EBX_DWORD_PTR_EBX()
	$OPCODE = $OPCODE & "8B1B"
EndFunc


Func MOV_EBX_DWORD_PTR_ECX()
	$OPCODE = $OPCODE & "8B19"
EndFunc


Func MOV_EBX_DWORD_PTR_EDX()
	$OPCODE = $OPCODE & "8B1A"
EndFunc


Func MOV_EBX_DWORD_PTR_EDI()
	$OPCODE = $OPCODE & "8B1F"
EndFunc


Func MOV_EBX_DWORD_PTR_ESP()
	$OPCODE = $OPCODE & "8B1C24"
EndFunc


Func MOV_EBX_DWORD_PTR_ESI()
	$OPCODE = $OPCODE & "8B1E"
EndFunc


Func MOV_ECX_DWORD_PTR_EAX()
	$OPCODE = $OPCODE & "8B08"
EndFunc


Func MOV_ECX_DWORD_PTR_EBP()
	$OPCODE = $OPCODE & "8B4D00"
EndFunc


Func MOV_ECX_DWORD_PTR_EBX()
	$OPCODE = $OPCODE & "8B0B"
EndFunc


Func MOV_ECX_DWORD_PTR_ECX()
	$OPCODE = $OPCODE & "8B09"
EndFunc


Func MOV_ECX_DWORD_PTR_EDX()
	$OPCODE = $OPCODE & "8B0A"
EndFunc


Func MOV_ECX_DWORD_PTR_EDI()
	$OPCODE = $OPCODE & "8B0F"
EndFunc


Func MOV_ECX_DWORD_PTR_ESP()
	$OPCODE = $OPCODE & "8B0C24"
EndFunc


Func MOV_ECX_DWORD_PTR_ESI()
	$OPCODE = $OPCODE & "8B0E"
EndFunc


Func MOV_EDX_DWORD_PTR_EAX()
	$OPCODE = $OPCODE & "8B10"
EndFunc


Func MOV_EDX_DWORD_PTR_EBP()
	$OPCODE = $OPCODE & "8B5500"
EndFunc


Func MOV_EDX_DWORD_PTR_EBX()
	$OPCODE = $OPCODE & "8B13"
EndFunc


Func MOV_EDX_DWORD_PTR_ECX()
	$OPCODE = $OPCODE & "8B11"
EndFunc


Func MOV_EDX_DWORD_PTR_EDX()
	$OPCODE = $OPCODE & "8B12"
EndFunc


Func MOV_EDX_DWORD_PTR_EDI()
	$OPCODE = $OPCODE & "8B17"
EndFunc


Func MOV_EDX_DWORD_PTR_ESI()
	$OPCODE = $OPCODE & "8B16"
EndFunc


Func MOV_EDX_DWORD_PTR_ESP()
	$OPCODE = $OPCODE & "8B1424"
EndFunc


Func MOV_EAX_EBP()
	$OPCODE = $OPCODE & "8BC5"
EndFunc


Func MOV_EAX_EBX()
	$OPCODE = $OPCODE & "8BC3"
EndFunc


Func MOV_EAX_ECX()
	$OPCODE = $OPCODE & "8BC1"
EndFunc


Func MOV_EAX_EDI()
	$OPCODE = $OPCODE & "8BC7"
EndFunc


Func MOV_EAX_EDX()
	$OPCODE = $OPCODE & "8BC2"
EndFunc


Func MOV_EAX_ESI()
	$OPCODE = $OPCODE & "8BC6"
EndFunc


Func MOV_EAX_ESP()
	$OPCODE = $OPCODE & "8BC4"
EndFunc


Func MOV_EBX_EBP()
	$OPCODE = $OPCODE & "8BDD"
EndFunc


Func MOV_EBX_EAX()
	$OPCODE = $OPCODE & "8BD8"
EndFunc


Func MOV_EBX_ECX()
	$OPCODE = $OPCODE & "8BD9"
EndFunc


Func MOV_EBX_EDI()
	$OPCODE = $OPCODE & "8BDF"
EndFunc


Func MOV_EBX_EDX()
	$OPCODE = $OPCODE & "8BDA"
EndFunc


Func MOV_EBX_ESI()
	$OPCODE = $OPCODE & "8BDE"
EndFunc


Func MOV_EBX_ESP()
	$OPCODE = $OPCODE & "8BDC"
EndFunc


Func MOV_ECX_EBP()
	$OPCODE = $OPCODE & "8BCD"
EndFunc


Func MOV_ECX_EAX()
	$OPCODE = $OPCODE & "8BC8"
EndFunc


Func MOV_ECX_EBX()
	$OPCODE = $OPCODE & "8BCB"
EndFunc


Func MOV_ECX_EDI()
	$OPCODE = $OPCODE & "8BCF"
EndFunc


Func MOV_ECX_EDX()
	$OPCODE = $OPCODE & "8BCA"
EndFunc


Func MOV_ECX_ESI()
	$OPCODE = $OPCODE & "8BCE"
EndFunc


Func MOV_ECX_ESP()
	$OPCODE = $OPCODE & "8BCC"
EndFunc


Func MOV_EDX_EBP()
	$OPCODE = $OPCODE & "8BD5"
EndFunc


Func MOV_EDX_EBX()
	$OPCODE = $OPCODE & "8BD3"
EndFunc


Func MOV_EDX_ECX()
	$OPCODE = $OPCODE & "8BD1"
EndFunc


Func MOV_EDX_EDI()
	$OPCODE = $OPCODE & "8BD7"
EndFunc


Func MOV_EDX_EAX()
	$OPCODE = $OPCODE & "8BD0"
EndFunc


Func MOV_EDX_ESI()
	$OPCODE = $OPCODE & "8BD6"
EndFunc


Func MOV_EDX_ESP()
	$OPCODE = $OPCODE & "8BD4"
EndFunc


Func MOV_ESI_EBP()
	$OPCODE = $OPCODE & "8BF5"
EndFunc


Func MOV_ESI_EBX()
	$OPCODE = $OPCODE & "8BF3"
EndFunc


Func MOV_ESI_ECX()
	$OPCODE = $OPCODE & "8BF1"
EndFunc


Func MOV_ESI_EDI()
	$OPCODE = $OPCODE & "8BF7"
EndFunc


Func MOV_ESI_EAX()
	$OPCODE = $OPCODE & "8BF0"
EndFunc


Func MOV_ESI_EDX()
	$OPCODE = $OPCODE & "8BF2"
EndFunc


Func MOV_ESI_ESP()
	$OPCODE = $OPCODE & "8BF4"
EndFunc


Func MOV_ESP_EBP()
	$OPCODE = $OPCODE & "8BE5"
EndFunc


Func MOV_ESP_EBX()
	$OPCODE = $OPCODE & "8BE3"
EndFunc


Func MOV_ESP_ECX()
	$OPCODE = $OPCODE & "8BE1"
EndFunc


Func MOV_ESP_EDI()
	$OPCODE = $OPCODE & "8BE7"
EndFunc


Func MOV_ESP_EAX()
	$OPCODE = $OPCODE & "8BE0"
EndFunc


Func MOV_ESP_EDX()
	$OPCODE = $OPCODE & "8BE2"
EndFunc


Func MOV_ESP_ESI()
	$OPCODE = $OPCODE & "8BE6"
EndFunc


Func MOV_EDI_EBP()
	$OPCODE = $OPCODE & "8BFD"
EndFunc


Func MOV_EDI_EAX()
	$OPCODE = $OPCODE & "8BF8"
EndFunc


Func MOV_EDI_EBX()
	$OPCODE = $OPCODE & "8BFB"
EndFunc


Func MOV_EDI_ECX()
	$OPCODE = $OPCODE & "8BF9"
EndFunc


Func MOV_EDI_EDX()
	$OPCODE = $OPCODE & "8BFA"
EndFunc


Func MOV_EDI_ESI()
	$OPCODE = $OPCODE & "8BFE"
EndFunc


Func MOV_EDI_ESP()
	$OPCODE = $OPCODE & "8BFC"
EndFunc


Func MOV_EBP_EDI()
	$OPCODE = $OPCODE & "8BDF"
EndFunc


Func MOV_EBP_EAX()
	$OPCODE = $OPCODE & "8BE8"
EndFunc


Func MOV_EBP_EBX()
	$OPCODE = $OPCODE & "8BEB"
EndFunc


Func MOV_EBP_ECX()
	$OPCODE = $OPCODE & "8BE9"
EndFunc


Func MOV_EBP_EDX()
	$OPCODE = $OPCODE & "8BEA"
EndFunc


Func MOV_EBP_ESI()
	$OPCODE = $OPCODE & "8BEE"
EndFunc


Func MOV_EBP_ESP()
	$OPCODE = $OPCODE & "8BEC"
EndFunc


Func PUSH($I)
	$OPCODE = $OPCODE & "68" & INT2HEX($I, 8)
EndFunc


Func PUSH_DWORD_PTR($I)
	$OPCODE = $OPCODE & "FF35" & INT2HEX($I, 8)
EndFunc


Func PUSH_EAX()
	$OPCODE = $OPCODE & "50"
EndFunc


Func PUSH_ECX()
	$OPCODE = $OPCODE & "51"
EndFunc


Func PUSH_EDX()
	$OPCODE = $OPCODE & "52"
EndFunc


Func PUSH_EBX()
	$OPCODE = $OPCODE & "53"
EndFunc


Func PUSH_ESP()
	$OPCODE = $OPCODE & "54"
EndFunc


Func PUSH_EBP()
	$OPCODE = $OPCODE & "55"
EndFunc


Func PUSH_ESI()
	$OPCODE = $OPCODE & "56"
EndFunc


Func PUSH_EDI()
	$OPCODE = $OPCODE & "57"
EndFunc


Func LEA_EAX_DWORD_PTR_EAX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D40" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D80" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EAX_DWORD_PTR_EBX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D43" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D83" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EAX_DWORD_PTR_ECX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D41" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D81" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EAX_DWORD_PTR_EDX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D42" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D82" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EAX_DWORD_PTR_ESI_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D46" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D86" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EAX_DWORD_PTR_ESP_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D40" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D80" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EAX_DWORD_PTR_EBP_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D4424" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D8424" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EAX_DWORD_PTR_EDI_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D47" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D87" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EBX_DWORD_PTR_EAX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D58" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D98" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EBX_DWORD_PTR_ESP_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D5C24" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D9C24" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EBX_DWORD_PTR_EBX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D5B" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D9B" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EBX_DWORD_PTR_ECX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D59" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D99" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EBX_DWORD_PTR_EDX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D5A" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D9A" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EBX_DWORD_PTR_EDI_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D5F" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D9F" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EBX_DWORD_PTR_EBP_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D5D" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D9D" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EBX_DWORD_PTR_ESI_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D5E" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D9E" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_ECX_DWORD_PTR_EAX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D48" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D88" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_ECX_DWORD_PTR_ESP_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D4C24" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D8C24" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_ECX_DWORD_PTR_EBX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D4B" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D8B" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_ECX_DWORD_PTR_ECX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D49" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D89" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_ECX_DWORD_PTR_EDX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D4A" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D8A" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_ECX_DWORD_PTR_EDI_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D4F" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D8F" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_ECX_DWORD_PTR_EBP_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D4D" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D8D" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_ECX_DWORD_PTR_ESI_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D4E" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D8E" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EDX_DWORD_PTR_EAX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D50" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D90" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EDX_DWORD_PTR_ESP_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D5424" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D9424" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EDX_DWORD_PTR_EBX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D53" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D93" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EDX_DWORD_PTR_ECX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D51" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D91" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EDX_DWORD_PTR_EDX_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D52" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D92" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EDX_DWORD_PTR_EDI_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D57" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D97" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EDX_DWORD_PTR_EBP_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D55" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D95" & INT2HEX($I, 8)
	EndIf
EndFunc


Func LEA_EDX_DWORD_PTR_ESI_ADD($I)
	If $I <= 255 Then
		$OPCODE = $OPCODE & "8D56" & INT2HEX($I, 2)
	Else
		$OPCODE = $OPCODE & "8D96" & INT2HEX($I, 8)
	EndIf
EndFunc


Func POP_EAX()
	$OPCODE = $OPCODE & "58"
EndFunc


Func POP_EBX()
	$OPCODE = $OPCODE & "5B"
EndFunc


Func POP_ECX()
	$OPCODE = $OPCODE & "59"
EndFunc


Func POP_EDX()
	$OPCODE = $OPCODE & "5A"
EndFunc


Func POP_ESI()
	$OPCODE = $OPCODE & "5E"
EndFunc


Func POP_ESP()
	$OPCODE = $OPCODE & "5C"
EndFunc


Func POP_EDI()
	$OPCODE = $OPCODE & "5F"
EndFunc


Func POP_EBP()
	$OPCODE = $OPCODE & "5D"
EndFunc


Func INJECTCODE($PID)
	If $PID <> 0 And $OPCODE <> "" Then
		Local $DATA = DllStructCreate("byte[" & StringLen($OPCODE) / 2 & "]")
		For $I = 1 To DllStructGetSize($DATA)
			DllStructSetData($DATA, 1, Dec(StringMid($OPCODE, ($I - 1) * 2 + 1, 2)), $I)
		Next
		Local $RESULT, $PROCESS, $ADD, $THREAD
		$RESULT = DllCall("Kernel32.Dll", "int", "OpenProcess", "int", 2035711, "int", 0, "int", $PID)
		$PROCESS = $RESULT[0]
		$RESULT = DllCall("Kernel32.dll", "ptr", "VirtualAllocEx", "int", $PROCESS, "ptr", 0, "int", DllStructGetSize($DATA), "int", 4096, "int", 64)
		$ADD = $RESULT[0]
		$RESULT = DllCall("kernel32.dll", "int", "WriteProcessMemory", "int", $PROCESS, "ptr", $ADD, "ptr", DllStructGetPtr($DATA), "int", DllStructGetSize($DATA), "int", 0)
		If $OPDEBUG Then
			MsgBox(0, "Debug", "AddWrite = " & Hex($ADD))
		EndIf
		$RESULT = DllCall("kernel32.dll", "int", "CreateRemoteThread", "int", $PROCESS, "ptr", 0, "int", 0, "int", $ADD, "ptr", 0, "int", 0, "int", 0)
		$THREAD = $RESULT[0]
		Do
			$RESULT = DllCall("kernel32.dll", "int", "WaitForSingleObject", "int", $THREAD, "int", 50)
		Until $RESULT[0] <> 258
		DllCall("Kernel32.dll", "int", "CloseHandle", "int", $THREAD)
		$RESULT = DllCall("Kernel32.dll", "ptr", "VirtualFreeEx", "hwnd", $PROCESS, "ptr", DllStructGetPtr($DATA), "int", DllStructGetSize($DATA), "int", 32768)
		DllCall("Kernel32.dll", "int", "CloseHandle", "int", $PROCESS)
		$OPCODE = ""
		$DATA = 0
	EndIf
EndFunc

Global Const $GUI_EVENT_CLOSE = -3
Global Const $GUI_EVENT_MINIMIZE = -4
Global Const $GUI_EVENT_RESTORE = -5
Global Const $GUI_EVENT_MAXIMIZE = -6
Global Const $GUI_EVENT_PRIMARYDOWN = -7
Global Const $GUI_EVENT_PRIMARYUP = -8
Global Const $GUI_EVENT_SECONDARYDOWN = -9
Global Const $GUI_EVENT_SECONDARYUP = -10
Global Const $GUI_EVENT_MOUSEMOVE = -11
Global Const $GUI_EVENT_RESIZED = -12
Global Const $GUI_EVENT_DROPPED = -13
Global Const $GUI_RUNDEFMSG = "GUI_RUNDEFMSG"
Global Const $GUI_AVISTOP = 0
Global Const $GUI_AVISTART = 1
Global Const $GUI_AVICLOSE = 2
Global Const $GUI_CHECKED = 1
Global Const $GUI_INDETERMINATE = 2
Global Const $GUI_UNCHECKED = 4
Global Const $GUI_DROPACCEPTED = 8
Global Const $GUI_NODROPACCEPTED = 4096
Global Const $GUI_ACCEPTFILES = $GUI_DROPACCEPTED
Global Const $GUI_SHOW = 16
Global Const $GUI_HIDE = 32
Global Const $GUI_ENABLE = 64
Global Const $GUI_DISABLE = 128
Global Const $GUI_FOCUS = 256
Global Const $GUI_NOFOCUS = 8192
Global Const $GUI_DEFBUTTON = 512
Global Const $GUI_EXPAND = 1024
Global Const $GUI_ONTOP = 2048
Global Const $GUI_FONTITALIC = 2
Global Const $GUI_FONTUNDER = 4
Global Const $GUI_FONTSTRIKE = 8
Global Const $GUI_DOCKAUTO = 1
Global Const $GUI_DOCKLEFT = 2
Global Const $GUI_DOCKRIGHT = 4
Global Const $GUI_DOCKHCENTER = 8
Global Const $GUI_DOCKTOP = 32
Global Const $GUI_DOCKBOTTOM = 64
Global Const $GUI_DOCKVCENTER = 128
Global Const $GUI_DOCKWIDTH = 256
Global Const $GUI_DOCKHEIGHT = 512
Global Const $GUI_DOCKSIZE = 768
Global Const $GUI_DOCKMENUBAR = 544
Global Const $GUI_DOCKSTATEBAR = 576
Global Const $GUI_DOCKALL = 802
Global Const $GUI_DOCKBORDERS = 102
Global Const $GUI_GR_CLOSE = 1
Global Const $GUI_GR_LINE = 2
Global Const $GUI_GR_BEZIER = 4
Global Const $GUI_GR_MOVE = 6
Global Const $GUI_GR_COLOR = 8
Global Const $GUI_GR_RECT = 10
Global Const $GUI_GR_ELLIPSE = 12
Global Const $GUI_GR_PIE = 14
Global Const $GUI_GR_DOT = 16
Global Const $GUI_GR_PIXEL = 18
Global Const $GUI_GR_HINT = 20
Global Const $GUI_GR_REFRESH = 22
Global Const $GUI_GR_PENSIZE = 24
Global Const $GUI_GR_NOBKCOLOR = -2
Global Const $GUI_BKCOLOR_DEFAULT = -1
Global Const $GUI_BKCOLOR_TRANSPARENT = -2
Global Const $GUI_BKCOLOR_LV_ALTERNATE = -33554432
Global Const $GUI_WS_EX_PARENTDRAG = 1048576
#NoTrayIcon
#Region ### START Koda GUI section ### Form=
$AUTOVL = GUICreate("Prist Tool", 367, 257, 192, 114)
GUISetOnEvent($GUI_EVENT_CLOSE, "AltQ", $AUTOVL)
GUISetOnEvent($GUI_EVENT_MINIMIZE, "MinimizeToTray", $AUTOVL)
$LABEL1 = GUICtrlCreateLabel("Персонаж", 4, 12, 57, 17)
$TITLE1_ID = GUICtrlCreateInput("Perfect World", 64, 8, 89, 21)
$LABEL2 = GUICtrlCreateLabel("Прист", 164, 12, 40, 17)
$TITLE2_ID = GUICtrlCreateInput("Perfect World 2", 212, 8, 89, 21)
$LABEL3 = GUICtrlCreateLabel("Имя:", 4, 36, 60, 17)
$NAME1_ID = GUICtrlCreateLabel("-----", 68, 36, 86, 17)
$LABEL5 = GUICtrlCreateLabel("Пр. Имя:", 164, 36, 51, 17)
$NAME2_ID = GUICtrlCreateLabel("-----", 220, 36, 82, 17)
$LABEL7 = GUICtrlCreateLabel("Перс HP:", 4, 60, 47, 17)
$HP1_ID = GUICtrlCreateLabel("0 / 0", 68, 60, 85, 17)
$LABEL9 = GUICtrlCreateLabel("Пр. HP:", 164, 60, 38, 17)
$HP2_ID = GUICtrlCreateLabel("0 / 0", 220, 60, 81, 17)
$LABEL11 = GUICtrlCreateLabel("Перс MP:", 4, 84, 48, 17)
$MP1_ID = GUICtrlCreateLabel("0 / 0", 68, 84, 85, 17)
$LABEL13 = GUICtrlCreateLabel("Пр MP:", 164, 84, 39, 17)
$MP2_ID = GUICtrlCreateLabel("0 / 0", 220, 84, 81, 17)
$SELFHP_CHECK_ID = GUICtrlCreateCheckbox("HP присту:", 4, 108, 121, 21)
$SELFHP_ID = GUICtrlCreateInput("500", 136, 108, 37, 21)
$LABEL15 = GUICtrlCreateLabel("HP         Key:", 176, 112, 68, 17)
$SKILL1_STRING_ID = GUICtrlCreateCombo("", 248, 108, 57, 25)
GUICtrlSetData(-1, "1|2|3|4|5|6|7|8|9|{F1}|{F2}|{F3}|{F4}|{F5}|{F6}|{F7}|{F8}", 1)
$SELFMP_CHECK_ID = GUICtrlCreateCheckbox("MP присту:", 4, 132, 129, 21)
$SELFMP_ID = GUICtrlCreateInput("500", 136, 132, 37, 21)
$LABEL16 = GUICtrlCreateLabel("MP         Key:", 176, 136, 69, 17)
$SKILL2_STRING_ID = GUICtrlCreateCombo("", 248, 132, 57, 25)
GUICtrlSetData(-1, "1|2|3|4|5|6|7|8|9|{F1}|{F2}|{F3}|{F4}|{F5}|{F6}|{F7}|{F8}", 2)
$HPVALUE_CHECK_ID = GUICtrlCreateCheckbox("Потерянно HP:", 4, 156, 121, 21)
$HPVALUE_ID = GUICtrlCreateInput("500", 136, 156, 37, 21)
$LABEL17 = GUICtrlCreateLabel("HP         Skill:", 176, 160, 68, 17)
$SKILL3_STRING_ID = GUICtrlCreateCombo("", 248, 156, 57, 25)
GUICtrlSetData(-1, "1|2|3|4|5|6|7|8|9|{F1}|{F2}|{F3}|{F4}|{F5}|{F6}|{F7}|{F8}", 1)
$HPTIME_CHECK_ID = GUICtrlCreateCheckbox("Временный бафф:", 4, 180, 121, 21)
$HPTIME_ID = GUICtrlCreateInput("10", 136, 180, 37, 21)
$LABEL18 = GUICtrlCreateLabel("s            Skill:", 176, 184, 67, 17)
$SKILL4_STRING_ID = GUICtrlCreateCombo("", 248, 180, 57, 25)
GUICtrlSetData(-1, "1|2|3|4|5|6|7|8|9|{F1}|{F2}|{F3}|{F4}|{F5}|{F6}|{F7}|{F8}", 1)
$REBUFF_CHECK_ID = GUICtrlCreateCheckbox("Бафф:", 4, 204, 121, 21)
$REBUFF_TIME_ID = GUICtrlCreateInput("1800", 136, 204, 37, 21)
$LABEL19 = GUICtrlCreateLabel("s            Skill:", 176, 208, 67, 17)
$SKILL5_STRING_ID = GUICtrlCreateCombo("", 248, 204, 57, 25)
GUICtrlSetData(-1, "1|2|3|4|5|6|7|8|9|{F1}|{F2}|{F3}|{F4}|{F5}|{F6}|{F7}|{F8}", 3)
$SKILL1_TIME_ID = GUICtrlCreateInput("2000", 308, 108, 37, 21)
$SKILL2_TIME_ID = GUICtrlCreateInput("100", 308, 132, 37, 21)
$SKILL3_TIME_ID = GUICtrlCreateInput("2000", 308, 156, 37, 21)
$SKILL4_TIME_ID = GUICtrlCreateInput("2000", 308, 180, 37, 21)
$SKILL5_TIME_ID = GUICtrlCreateInput("8000", 308, 204, 37, 21)
$LABEL20 = GUICtrlCreateLabel("ms", 348, 208, 17, 17)
$LABEL21 = GUICtrlCreateLabel("ms", 348, 136, 17, 17)
$LABEL22 = GUICtrlCreateLabel("ms", 348, 160, 17, 17)
$LABEL23 = GUICtrlCreateLabel("ms", 348, 184, 17, 17)
$LABEL24 = GUICtrlCreateLabel("ms", 348, 112, 17, 17)
$DOITEN_ID = GUICtrlCreateButton("См Имя", 308, 8, 53, 21, 0)
GUICtrlSetOnEvent($DOITEN_ID, "Add_ID")
$START_ID = GUICtrlCreateButton("Старт", 308, 32, 53, 21, 0)
GUICtrlSetOnEvent($START_ID, "Load")
$EXIT_ID = GUICtrlCreateButton("Выход", 308, 56, 53, 21, 0)
GUICtrlSetOnEvent($EXIT_ID, "AltQ")
$REFRESH_ID = GUICtrlCreateButton("Обновить", 290, 80, 68, 21, 0)
GUICtrlSetOnEvent($REFRESH_ID, "Update")
$LABEL25 = GUICtrlCreateLabel("Высота от персонажа:", 4, 232, 128, 17)
$HIGH_ID = GUICtrlCreateInput("2.5", 136, 228, 37, 21)
$LABEL26 = GUICtrlCreateLabel("m", 176, 232, 12, 17)
$Label4 = GUICtrlCreateLabel("for Zhyk.ru", 312, 240, 55, 17)
TraySetClick(16)
$TRAYRESUM = TrayCreateItem("Resum")
TrayItemSetOnEvent($TRAYRESUM, "Resum")
$TRAYEXIT = TrayCreateItem("Exit")
TrayItemSetOnEvent($TRAYEXIT, "AltQ")
GUISetState(@SW_SHOW)
Opt("GUIOnEventMode", 1)
Opt("WinTitleMatchMode", 3)
#EndRegion ### END Koda GUI section ###
Dim $SELFHP_CHECK, $SELFHP_VALUE, $SELFHP_STRING, $SELFHP_TIME, $SELFMP_CHECK, $SELFMP_VALUE, $SELFMP_STRING, $SELFMP_TIME
Dim $HPVALUE_CHECK, $HPVALUE_VALUE, $HPVALUE_STRING, $HPVALUE_TIME, $HPTIME_CHECK, $HPTIME_VALUE, $HPTIME_STRING, $HPTIME_TIME
Dim $REBUFF_CHECK, $REBUFF_VALUE, $REBUFF_STRING, $REBUFF_TIME, $STARTOK, $TITLE1, $TITLE2, $PID1, $MEMID1, $PID2, $MEMID2
Dim $PLAYER1_HP_ADD, $PLAYER1_X_ADD, $PLAYER1_NAME, $PLAYER1_HP, $PLAYER1_HPM, $PLAYER1_MP, $PLAYER1_MPM, $PLAYER1_X, $PLAYER1_Y, $PLAYER1_Z
Dim $PLAYER2_HP_ADD, $PLAYER2_X_ADD, $PLAYER2_NAME, $PLAYER2_HP, $PLAYER2_HPM, $PLAYER2_MP, $PLAYER2_MPM, $PLAYER2_X, $PLAYER2_Y, $PLAYER2_Z, $PLAYER2_TARGETID_ADD, $PLAYER2_TARGETID
Dim $MOVE_STAMP, $HPTIME_STAMP, $REBUFF_STAMP, $HIGH, $ROOTADD = 10227308, $BASEADD = 10229012, $PLAYER1_ID, $PLAYER2_ID
While 1
	If $STARTOK Then
		REFRESH()
	EndIf
	Sleep(500)
WEnd

Func LOAD()
	$STARTOK = Not $STARTOK
	If $STARTOK Then
		$TITLE1 = GUICtrlRead($TITLE1_ID)
		If Not WinExists($TITLE1) Then
			$STARTOK = False
			GUICtrlSetData($NAME1_ID, "-----")
			GUICtrlSetData($HP1_ID, "0 / 0")
			GUICtrlSetData($MP1_ID, "0 / 0")
			MsgBox(0, "Ошибка", "Окно с именем: " & $TITLE1 & " не существует =)")
		EndIf
	EndIf
	If $STARTOK Then
		$TITLE2 = GUICtrlRead($TITLE2_ID)
		If Not WinExists($TITLE2) Then
			$STARTOK = False
			GUICtrlSetData($NAME2_ID, "-----")
			GUICtrlSetData($HP2_ID, "0 / 0")
			GUICtrlSetData($MP2_ID, "0 / 0")
			MsgBox(0, "Ошибка", "Окно с именем: " & $TITLE2 & " не существует =)")
		EndIf
	EndIf
	If $STARTOK Then
		GUICtrlSetData($START_ID, "Стоп")
		$PID1 = WinGetProcess($TITLE1)
		$MEMID1 = _MEMORYOPEN($PID1)
		$PID2 = WinGetProcess($TITLE2)
		$MEMID2 = _MEMORYOPEN($PID2)
		_MEMORYWRITE(4210637, $MEMID1, 28313067)
		_MEMORYWRITE(4210637, $MEMID2, 28313067)
		GETPLAYERINFO()
		REFRESHPLAYERINFO()
		If GUICtrlRead($SELFHP_CHECK_ID) = $GUI_CHECKED Then
			$SELFHP_CHECK = True
			$SELFHP_VALUE = GUICtrlRead($SELFHP_ID)
			$SELFHP_STRING = GUICtrlRead($SKILL1_STRING_ID)
			$SELFHP_TIME = GUICtrlRead($SKILL1_TIME_ID)
		Else
			$SELFHP_CHECK = False
		EndIf
		If GUICtrlRead($SELFMP_CHECK_ID) = $GUI_CHECKED Then
			$SELFMP_CHECK = True
			$SELFMP_VALUE = GUICtrlRead($SELFMP_ID)
			$SELFMP_STRING = GUICtrlRead($SKILL2_STRING_ID)
			$SELFMP_TIME = GUICtrlRead($SKILL2_TIME_ID)
		Else
			$SELFMP_CHECK = False
		EndIf
		If GUICtrlRead($HPVALUE_CHECK_ID) = $GUI_CHECKED Then
			$HPVALUE_CHECK = True
			$HPVALUE_VALUE = GUICtrlRead($HPVALUE_ID)
			$HPVALUE_STRING = GUICtrlRead($SKILL3_STRING_ID)
			$HPVALUE_TIME = GUICtrlRead($SKILL3_TIME_ID)
		Else
			$HPVALUE_CHECK = False
		EndIf
		If GUICtrlRead($HPTIME_CHECK_ID) = $GUI_CHECKED Then
			$HPTIME_CHECK = True
			$HPTIME_VALUE = GUICtrlRead($HPTIME_ID)
			$HPTIME_STRING = GUICtrlRead($SKILL4_STRING_ID)
			$HPTIME_TIME = GUICtrlRead($SKILL4_TIME_ID)
			$HPTIME_STAMP = TimerInit()
		Else
			$HPTIME_CHECK = False
		EndIf
		If GUICtrlRead($REBUFF_CHECK_ID) = $GUI_CHECKED Then
			$REBUFF_CHECK = True
			$REBUFF_VALUE = GUICtrlRead($REBUFF_TIME_ID)
			$REBUFF_STRING = GUICtrlRead($SKILL5_STRING_ID)
			$REBUFF_TIME = GUICtrlRead($SKILL5_TIME_ID)
			ControlSend($TITLE2, "", "", $REBUFF_STRING)
			$REBUFF_STAMP = TimerInit()
			Sleep($REBUFF_TIME)
		Else
			$REBUFF_CHECK = False
		EndIf
		$HIGH = GUICtrlRead($HIGH_ID)
		$PLAYER1_ID = _MEMORYREAD(10227468, $MEMID1)
		$PLAYER2_ID = _MEMORYREAD(10227468, $MEMID2)
		$PLAYER1_NAME = _MEMORYREAD(_MEMORYREAD(_MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID1) + 32, $MEMID1) + 1544, $MEMID1), $MEMID1, "wchar[9]")
		GUICtrlSetData($NAME1_ID, $PLAYER1_NAME)
		$PLAYER2_NAME = _MEMORYREAD(_MEMORYREAD(_MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID2) + 32, $MEMID2) + 1544, $MEMID2), $MEMID2, "wchar[9]")
		GUICtrlSetData($NAME2_ID, $PLAYER2_NAME)
		$PLAYER1_HP_ADD = _MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID1) + 32, $MEMID1) + 1132
		$PLAYER2_HP_ADD = _MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID2) + 32, $MEMID2) + 1132
		$PLAYER1_X_ADD = _MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID1) + 32, $MEMID1) + 60
		$PLAYER2_X_ADD = _MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID2) + 32, $MEMID2) + 60
		$PLAYER2_TARGETID_ADD = _MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID2) + 32, $MEMID2) + 2808
		$PLAYER1_JOB = _MEMORYREAD(_MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID1) + 32, $MEMID1) + 1552, $MEMID1)
		Switch $PLAYER1_JOB
			Case 0
				GUICtrlSetData($LABEL3, "Вар")
			Case 1
				GUICtrlSetData($LABEL3, "Маг")
			Case 3
				GUICtrlSetData($LABEL3, "Друля")
			Case 4
				GUICtrlSetData($LABEL3, "Обор")
			Case 6
				GUICtrlSetData($LABEL3, "Лук")
			Case 7
				GUICtrlSetData($LABEL3, "Прист")
			Case Else
				GUICtrlSetData($LABEL3, "Амфибия")
		EndSwitch
		$PLAYER2_JOB = _MEMORYREAD(_MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID2) + 32, $MEMID2) + 1552, $MEMID2)
		Switch $PLAYER2_JOB
			Case 0
				GUICtrlSetData($LABEL5, "Вар")
			Case 1
				GUICtrlSetData($LABEL5, "Маг")
			Case 3
				GUICtrlSetData($LABEL5, "Друля")
			Case 4
				GUICtrlSetData($LABEL5, "Обор")
			Case 6
				GUICtrlSetData($LABEL5, "Лук")
			Case 7
				GUICtrlSetData($LABEL5, "Прист")
			Case Else
				GUICtrlSetData($LABEL3, "Амфибия")
		EndSwitch
		$MOVE_STAMP = TimerInit()
	Else
		GUICtrlSetData($START_ID, "Старт")
	EndIf
EndFunc


Func GETPLAYERINFO()
	$PLAYER1_HP = _MEMORYREAD($PLAYER1_HP_ADD, $MEMID1)
	$PLAYER1_HPM = _MEMORYREAD($PLAYER1_HP_ADD + 56, $MEMID1)
	$PLAYER1_MP = _MEMORYREAD($PLAYER1_HP_ADD + 4, $MEMID1)
	$PLAYER1_MPM = _MEMORYREAD($PLAYER1_HP_ADD + 60, $MEMID1)
	$PLAYER1_X = _MEMORYREAD($PLAYER1_X_ADD, $MEMID1, "float")
	$PLAYER1_Y = _MEMORYREAD($PLAYER1_X_ADD + 8, $MEMID1, "float")
	$PLAYER1_Z = _MEMORYREAD($PLAYER1_X_ADD + 4, $MEMID1, "float")
	$PLAYER2_HP = _MEMORYREAD($PLAYER2_HP_ADD, $MEMID2)
	$PLAYER2_HPM = _MEMORYREAD($PLAYER2_HP_ADD + 56, $MEMID2)
	$PLAYER2_MP = _MEMORYREAD($PLAYER2_HP_ADD + 4, $MEMID2)
	$PLAYER2_MPM = _MEMORYREAD($PLAYER2_HP_ADD + 60, $MEMID2)
	$PLAYER2_X = _MEMORYREAD($PLAYER2_X_ADD, $MEMID2, "float")
	$PLAYER2_Y = _MEMORYREAD($PLAYER2_X_ADD + 8, $MEMID2, "float")
	$PLAYER2_Z = _MEMORYREAD($PLAYER2_X_ADD + 4, $MEMID2, "float")
	$PLAYER2_TARGETID = _MEMORYREAD($PLAYER2_TARGETID_ADD, $MEMID2)
EndFunc


Func REFRESHPLAYERINFO()
	GUICtrlSetData($HP1_ID, $PLAYER1_HP & " / " & $PLAYER1_HPM)
	GUICtrlSetData($HP2_ID, $PLAYER2_HP & " / " & $PLAYER2_HPM)
	GUICtrlSetData($MP1_ID, $PLAYER1_MP & " / " & $PLAYER1_MPM)
	GUICtrlSetData($MP2_ID, $PLAYER2_MP & " / " & $PLAYER2_MPM)
EndFunc


Func GETCURRENTMOBID($MEMID)
	$CURMOBID = _MEMORYREAD(_MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID) + 32, $MEMID) + 2808, $MEMID)
	Return $CURMOBID
EndFunc


Func SETCURENTMOBID($ID, $MEMID, $PID)
	_MEMORYWRITE(_MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID) + 32, $MEMID) + 2808, $MEMID, $ID)
	$OPCODE = ""
	PUSHAD()
	MOV_EAX_DWORD_PTR($ROOTADD)
	PUSH($ID)
	MOV_ECX_DWORD_PTR_EAX_ADD(32)
	$OPCODE &= "81c1ec000000"
	MOV_EDX(6101408)
	CALL_EDX()
	POPAD()
	RET()
	INJECTCODE($PID)
EndFunc


Func AUTORUN($X, $Y, $Z, $MEMID, $PID)
	Local $RESULT, $PROCESS, $CODE_ADD, $THREAD, $PARAM_ADD
	Local $PARAM = DllStructCreate("float [3]")
	DllStructSetData($PARAM, 1, $X, 1)
	DllStructSetData($PARAM, 1, $Z, 2)
	DllStructSetData($PARAM, 1, $Y, 3)
	$RESULT = DllCall("Kernel32.Dll", "int", "OpenProcess", "int", 2035711, "int", 0, "int", $PID)
	$PROCESS = $RESULT[0]
	$RESULT = DllCall("Kernel32.dll", "ptr", "VirtualAllocEx", "int", $PROCESS, "ptr", 0, "int", DllStructGetSize($PARAM), "int", 4096, "int", 64)
	$PARAM_ADD = $RESULT[0]
	$RESULT = DllCall("kernel32.dll", "int", "WriteProcessMemory", "int", $PROCESS, "ptr", $PARAM_ADD, "ptr", DllStructGetPtr($PARAM), "int", DllStructGetSize($PARAM), "int", 0)
	Local $FLY = 0
	Local $A = _MEMORYREAD($ROOTADD, $MEMID)
	$A = _MEMORYREAD($A + 28, $MEMID)
	$A = _MEMORYREAD($A + 32, $MEMID)
	$A = _MEMORYREAD($A + 1564, $MEMID)
	If $A = 2 Or $A = 1 Then
		$FLY = 1
	EndIf
	$OPCODE = ""
	PUSHAD()
	MOV_EDX($ROOTADD)
	MOV_ECX_DWORD_PTR_EDX()
	MOV_EDX_DWORD_PTR_ECX_ADD(28)
	$OPCODE &= "8B7220"
	MOV_ECX_DWORD_PTR_ESI_ADD(4064)
	MOV_EAX_DWORD_PTR_ESI_ADD(1564)
	PUSH(1)
	MOV_EDX(4620400)
	CALL_EDX()
	MOV_EDI_EAX()
	PUSH($PARAM_ADD)
	PUSH($FLY)
	MOV_ECX_EDI()
	MOV_EDX(4635824)
	CALL_EDX()
	PUSH(0)
	PUSH(1)
	PUSH_EDI()
	PUSH(1)
	MOV_ECX_DWORD_PTR_ESI_ADD(4064)
	MOV_EDX(4621424)
	CALL_EDX()
	POPAD()
	RET()
	INJECTCODE($PID)
EndFunc


Func REFRESH()
	GETPLAYERINFO()
	REFRESHPLAYERINFO()
	If $SELFHP_CHECK Then
		If $PLAYER2_HPM - $PLAYER2_HP >= $SELFHP_VALUE Then
			SETCURENTMOBID($PLAYER2_ID, $MEMID2, $PID2)
			ControlSend($TITLE2, "", "", $SELFHP_STRING)
			Sleep($SELFHP_TIME)
			SETCURENTMOBID($PLAYER1_ID, $MEMID2, $PID2)
		EndIf
	EndIf
	If $SELFMP_CHECK Then
		If $PLAYER2_MPM - $PLAYER2_MP >= $SELFMP_VALUE Then
			ControlSend($TITLE2, "", "", $SELFMP_STRING)
			Sleep($SELFMP_TIME)
		EndIf
	EndIf
	If $HPVALUE_CHECK Then
		If $PLAYER1_HPM - $PLAYER1_HP >= $HPVALUE_VALUE Then
			ControlSend($TITLE2, "", "", $HPVALUE_STRING)
			Sleep($HPVALUE_TIME)
		EndIf
	EndIf
	If $HPTIME_CHECK Then
		If TimerDiff($HPTIME_STAMP) >= $HPTIME_VALUE * 1000 Then
			ControlSend($TITLE2, "", "", $HPTIME_STRING)
			$HPTIME_STAMP = TimerInit()
			Sleep($HPTIME_TIME)
		EndIf
	EndIf
	If $REBUFF_CHECK Then
		If TimerDiff($REBUFF_STAMP) >= $REBUFF_VALUE * 1000 Then
			ControlSend($TITLE2, "", "", $REBUFF_STRING)
			$REBUFF_STAMP = TimerInit()
			Sleep($REBUFF_TIME)
		EndIf
	EndIf
	If (TimerDiff($MOVE_STAMP) >= 5000) And (Sqrt(($PLAYER1_X - $PLAYER2_X) * ($PLAYER1_X - $PLAYER2_X) + ($PLAYER1_Y - $PLAYER2_Y) * ($PLAYER1_Y - $PLAYER2_Y)) < 200) Then
		AUTORUN($PLAYER1_X, $PLAYER1_Y, $PLAYER1_Z + $HIGH * 10, $MEMID2, $PID2)
		$MOVE_STAMP = TimerInit()
	EndIf
	If (GETCURRENTMOBID($MEMID2) <> $PLAYER1_ID) And (Sqrt(($PLAYER1_X - $PLAYER2_X) * ($PLAYER1_X - $PLAYER2_X) + ($PLAYER1_Y - $PLAYER2_Y) * ($PLAYER1_Y - $PLAYER2_Y)) < 200) Then
		SETCURENTMOBID($PLAYER1_ID, $MEMID2, $PID2)
	EndIf
EndFunc


Func UPDATE()
	$TITLE1 = GUICtrlRead($TITLE1_ID)
	If Not WinExists($TITLE1) Then
		$STARTOK = False
		GUICtrlSetData($NAME1_ID, "-----")
		GUICtrlSetData($HP1_ID, "0 / 0")
		GUICtrlSetData($MP1_ID, "0 / 0")
		MsgBox(0, "Ошибка", "Окно с именем: " & $TITLE1 & " не существует =)")
	Else
		$PID1 = WinGetProcess($TITLE1)
		$MEMID1 = _MEMORYOPEN($PID1)
		$PLAYER1_HP_ADD = _MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID1) + 32, $MEMID1) + 1132
		$PLAYER1_HP = _MEMORYREAD($PLAYER1_HP_ADD, $MEMID1)
		$PLAYER1_HPM = _MEMORYREAD($PLAYER1_HP_ADD + 56, $MEMID1)
		$PLAYER1_MP = _MEMORYREAD($PLAYER1_HP_ADD + 4, $MEMID1)
		$PLAYER1_MPM = _MEMORYREAD($PLAYER1_HP_ADD + 60, $MEMID1)
		$PLAYER1_NAME = _MEMORYREAD(_MEMORYREAD(_MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID1) + 32, $MEMID1) + 1544, $MEMID1), $MEMID1, "wchar[9]")
		GUICtrlSetData($HP1_ID, $PLAYER1_HP & " / " & $PLAYER1_HPM)
		GUICtrlSetData($MP1_ID, $PLAYER1_MP & " / " & $PLAYER1_MPM)
		GUICtrlSetData($NAME1_ID, $PLAYER1_NAME)
	EndIf
	$TITLE2 = GUICtrlRead($TITLE2_ID)
	If Not WinExists($TITLE2) Then
		$STARTOK = False
		GUICtrlSetData($NAME2_ID, "-----")
		GUICtrlSetData($HP2_ID, "0 / 0")
		GUICtrlSetData($MP2_ID, "0 / 0")
		MsgBox(0, "Ошибка", "Окно с именем: " & $TITLE2 & " не существует =)")
	Else
		$PID2 = WinGetProcess($TITLE2)
		$MEMID2 = _MEMORYOPEN($PID2)
		$PLAYER2_HP_ADD = _MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID2) + 32, $MEMID2) + 1132
		$PLAYER2_HP = _MEMORYREAD($PLAYER2_HP_ADD, $MEMID2)
		$PLAYER2_HPM = _MEMORYREAD($PLAYER2_HP_ADD + 56, $MEMID2)
		$PLAYER2_MP = _MEMORYREAD($PLAYER2_HP_ADD + 4, $MEMID2)
		$PLAYER2_MPM = _MEMORYREAD($PLAYER2_HP_ADD + 60, $MEMID2)
		$PLAYER2_NAME = _MEMORYREAD(_MEMORYREAD(_MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID2) + 32, $MEMID2) + 1544, $MEMID2), $MEMID2, "wchar[9]")
		GUICtrlSetData($HP2_ID, $PLAYER2_HP & " / " & $PLAYER2_HPM)
		GUICtrlSetData($MP2_ID, $PLAYER2_MP & " / " & $PLAYER2_MPM)
		GUICtrlSetData($NAME2_ID, $PLAYER2_NAME)
	EndIf
	If GUICtrlRead($SELFHP_CHECK_ID) = $GUI_CHECKED Then
		$SELFHP_CHECK = True
		$SELFHP_VALUE = GUICtrlRead($SELFHP_ID)
		$SELFHP_STRING = GUICtrlRead($SKILL1_STRING_ID)
		$SELFHP_TIME = GUICtrlRead($SKILL1_TIME_ID)
	Else
		$SELFHP_CHECK = False
	EndIf
	If GUICtrlRead($SELFMP_CHECK_ID) = $GUI_CHECKED Then
		$SELFMP_CHECK = True
		$SELFMP_VALUE = GUICtrlRead($SELFMP_ID)
		$SELFMP_STRING = GUICtrlRead($SKILL2_STRING_ID)
		$SELFMP_TIME = GUICtrlRead($SKILL2_TIME_ID)
	Else
		$SELFMP_CHECK = False
	EndIf
	If GUICtrlRead($HPVALUE_CHECK_ID) = $GUI_CHECKED Then
		$HPVALUE_CHECK = True
		$HPVALUE_VALUE = GUICtrlRead($HPVALUE_ID)
		$HPVALUE_STRING = GUICtrlRead($SKILL3_STRING_ID)
		$HPVALUE_TIME = GUICtrlRead($SKILL3_TIME_ID)
	Else
		$HPVALUE_CHECK = False
	EndIf
	If GUICtrlRead($HPTIME_CHECK_ID) = $GUI_CHECKED Then
		$HPTIME_CHECK = True
		$HPTIME_VALUE = GUICtrlRead($HPTIME_ID)
		$HPTIME_STRING = GUICtrlRead($SKILL4_STRING_ID)
		$HPTIME_TIME = GUICtrlRead($SKILL4_TIME_ID)
	Else
		$HPTIME_CHECK = False
	EndIf
	If GUICtrlRead($REBUFF_CHECK_ID) = $GUI_CHECKED Then
		$REBUFF_CHECK = True
		$REBUFF_VALUE = GUICtrlRead($REBUFF_TIME_ID)
		$REBUFF_STRING = GUICtrlRead($SKILL5_STRING_ID)
		$REBUFF_TIME = GUICtrlRead($SKILL5_TIME_ID)
	Else
		$REBUFF_CHECK = False
	EndIf
	$HIGH = GUICtrlRead($HIGH_ID)
	$PLAYER1_ID = _MEMORYREAD(10227468, $MEMID1)
	$PLAYER2_ID = _MEMORYREAD(10227468, $MEMID2)
	$PLAYER1_NAME = _MEMORYREAD(_MEMORYREAD(_MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID1) + 32, $MEMID1) + 1524, $MEMID1), $MEMID1, "wchar[9]")
	$PLAYER2_NAME = _MEMORYREAD(_MEMORYREAD(_MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID2) + 32, $MEMID2) + 1524, $MEMID2), $MEMID2, "wchar[9]")
	$PLAYER1_HP_ADD = _MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID1) + 32, $MEMID1) + 1132
	$PLAYER2_MP_ADD = _MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID2) + 32, $MEMID2) + 1132
	$PLAYER1_X_ADD = _MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID1) + 32, $MEMID1) + 60
	$PLAYER2_X_ADD = _MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID2) + 32, $MEMID2) + 60
	$PLAYER2_TARGETID_ADD = _MEMORYREAD(_MEMORYREAD($BASEADD, $MEMID2) + 32, $MEMID2) + 2808
EndFunc


Func ADD_ID()
	WinSetTitle(GUICtrlRead($TITLE1_ID), "", GUICtrlRead($TITLE2_ID))
EndFunc


Func MINIMIZETOTRAY()
	Opt("TrayMenuMode", 1)
	Opt("TrayIconHide", 0)
	Opt("TrayOnEventMode", 1)
	TraySetToolTip("Prist Tool " & $TITLE1 & " vs " & $TITLE2)
	GUISetState(@SW_HIDE, $AUTOVL)
EndFunc


Func RESUM()
	GUISetState(@SW_SHOW, $AUTOVL)
	GUISetState(@SW_RESTORE, $AUTOVL)
	Opt("TrayIconHide", 1)
EndFunc


Func ALTQ()
	_MEMORYCLOSE($MEMID2)
	_MEMORYCLOSE($MEMID1)
	Exit
EndFunc